/*
 * Main.java
 *
 * Created on 2009-12-06, 15:39:29
 *
 * Author: Sebastian Sieczko
 */
package JDiskCat;

import java.awt.*;
import java.io.*;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.*;
import javax.swing.*;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 *
 * @author sebe
 */
public class Main extends javax.swing.JFrame implements Runnable {

    private String dirName;
    private String diskPath;
    private String type;
    private static String selected;//selected item from volume list
    private String path;
    private PrintWriter out = null;
    private static DefaultListModel listModel;
    private DefaultTableModel tableModel;
    private Vector columns;
    private Vector data;
    private DocumentBuilder loader;
    private Document document;
    private Node parent;
    private Node root;
    private NodeList list;
    private static boolean nerdMode = false;
    //private JOptionPane optionpane = new JOptionPane();
    private Map<Object, Icon> icons;
    private final Boolean unix;
    private static Preferences prefs;
    Thread dirListThread;
    ProgressWindow progressWindow = new ProgressWindow();
    SettingsWindow settingsWindow = new SettingsWindow();

    public Main() {
        listModel = new DefaultListModel();

        prefs = Preferences.userNodeForPackage(this.getClass());
        //prefs.put("LAST_OUTPUT_DIR", mostRecentOutputDirectory.getAbsolutePath());

        java.io.File currentDir = new java.io.File(System.getProperty("user.dir"));
        String userDir = currentDir.getAbsolutePath();
        int isUnix = userDir.lastIndexOf("/");
        unix = isUnix != -1;
        System.out.println("unix: " + unix);

        initComponents();
        columns = new Vector(3);
        columns.add("Name");
        columns.add("Size");
        columns.add("Date");
        tableModel = new DefaultTableModel();
        jTable1.setModel(tableModel);
        refreshDiskList();

        // pobranie rozmiarow aplikacji
        Dimension dialogSize = getSize();
        // pobranie rozdzielczosci pulpitu
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (dialogSize.height > screenSize.height) {
            dialogSize.height = screenSize.height;
        }
        if (dialogSize.width > screenSize.width) {
            dialogSize.height = screenSize.width;
        }

        // rozmieszczenie aplikacji na srodku ekranu
        setLocation((screenSize.width - dialogSize.width) / 2,
                (screenSize.height - dialogSize.height) / 2);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jToolBar1 = new javax.swing.JToolBar();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jButton9 = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JToolBar.Separator();
        jButton3 = new javax.swing.JButton();
        jButton4 = new javax.swing.JButton();
        jSeparator4 = new javax.swing.JToolBar.Separator();
        jButton7 = new javax.swing.JButton();
        jButton8 = new javax.swing.JButton();
        jSeparator2 = new javax.swing.JToolBar.Separator();
        jButton5 = new javax.swing.JButton();
        jSeparator3 = new javax.swing.JToolBar.Separator();
        jButton6 = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jSplitPane1 = new javax.swing.JSplitPane();
        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenu1 = new javax.swing.JMenu();
        jMenuItem3 = new javax.swing.JMenuItem();
        jMenuItem4 = new javax.swing.JMenuItem();
        jMenuItem5 = new javax.swing.JMenuItem();
        jMenuItem1 = new javax.swing.JMenuItem();
        jMenu2 = new javax.swing.JMenu();
        jMenuItem2 = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("JDiskCat 1.3.4");
        setBounds(new java.awt.Rectangle(0, 0, 0, 0));

        jButton1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/JDiskCat/img/list-add.png"))); // NOI18N
        jButton1.setToolTipText("Add volume");
        jButton1.setFocusable(false);
        jButton1.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton1.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jButton1MouseReleased(evt);
            }
        });
        jToolBar1.add(jButton1);

        jButton2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/JDiskCat/img/list-remove.png"))); // NOI18N
        jButton2.setToolTipText("Remove volume");
        jButton2.setEnabled(false);
        jButton2.setFocusable(false);
        jButton2.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton2.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jButton2MouseReleased(evt);
            }
        });
        jToolBar1.add(jButton2);

        jButton9.setIcon(new javax.swing.ImageIcon(getClass().getResource("/JDiskCat/img/document-properties.png"))); // NOI18N
        jButton9.setToolTipText("Display volume info");
        jButton9.setEnabled(false);
        jButton9.setFocusable(false);
        jButton9.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton9.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton9.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jButton9MouseReleased(evt);
            }
        });
        jToolBar1.add(jButton9);
        jToolBar1.add(jSeparator1);

        jButton3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/JDiskCat/img/go-home.png"))); // NOI18N
        jButton3.setToolTipText("Jump to root folder");
        jButton3.setEnabled(false);
        jButton3.setFocusable(false);
        jButton3.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton3.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton3.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jButton3MouseReleased(evt);
            }
        });
        jToolBar1.add(jButton3);

        jButton4.setIcon(new javax.swing.ImageIcon(getClass().getResource("/JDiskCat/img/go-up.png"))); // NOI18N
        jButton4.setToolTipText("Jump to parent folder");
        jButton4.setEnabled(false);
        jButton4.setFocusable(false);
        jButton4.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton4.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton4.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jButton4MouseReleased(evt);
            }
        });
        jToolBar1.add(jButton4);
        jToolBar1.add(jSeparator4);

        jButton7.setIcon(new javax.swing.ImageIcon(getClass().getResource("/JDiskCat/img/document-open.png"))); // NOI18N
        jButton7.setToolTipText("Open file in registered application");
        jButton7.setEnabled(false);
        jButton7.setFocusable(false);
        jButton7.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton7.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton7.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jButton7MouseReleased(evt);
            }
        });
        jToolBar1.add(jButton7);

        jButton8.setIcon(new javax.swing.ImageIcon(getClass().getResource("/JDiskCat/img/folder-open.png"))); // NOI18N
        jButton8.setToolTipText("Open containing folder");
        jButton8.setEnabled(false);
        jButton8.setFocusable(false);
        jButton8.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton8.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton8.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jButton8MouseReleased(evt);
            }
        });
        jToolBar1.add(jButton8);
        jToolBar1.add(jSeparator2);

        jButton5.setIcon(new javax.swing.ImageIcon(getClass().getResource("/JDiskCat/img/system-search.png"))); // NOI18N
        jButton5.setToolTipText("Open search window");
        jButton5.setEnabled(false);
        jButton5.setFocusable(false);
        jButton5.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton5.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton5.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jButton5MouseReleased(evt);
            }
        });
        jToolBar1.add(jButton5);
        jToolBar1.add(jSeparator3);

        jButton6.setIcon(new javax.swing.ImageIcon(getClass().getResource("/JDiskCat/img/system-log-out.png"))); // NOI18N
        jButton6.setToolTipText("Exit program");
        jButton6.setFocusable(false);
        jButton6.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton6.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton6.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jButton6MouseReleased(evt);
            }
        });
        jToolBar1.add(jButton6);

        jPanel1.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        jLabel1.setText(" ");

        jLabel2.setText(" ");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 455, Short.MAX_VALUE)
                .addGap(28, 28, 28)
                .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 153, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                .addComponent(jLabel2)
                .addComponent(jLabel1))
        );

        jSplitPane1.setResizeWeight(0.4);
        jSplitPane1.setDoubleBuffered(true);

        jList1.setModel(listModel);
        jList1.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jList1.setDoubleBuffered(true);
        jList1.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jList1ValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(jList1);

        jSplitPane1.setLeftComponent(jScrollPane1);

        jTable1.setAutoCreateRowSorter(true);
        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null}
            },
            new String [] {
                "Nazwa", "Wielkość", "Data"
            }
        ));
        jTable1.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_NEXT_COLUMN);
        jTable1.setDoubleBuffered(true);
        jTable1.setEditingColumn(0);
        jTable1.setEditingRow(0);
        jTable1.setFillsViewportHeight(true);
        jTable1.setGridColor(new java.awt.Color(0, 0, 0));
        jTable1.setIntercellSpacing(new java.awt.Dimension(0, 0));
        jTable1.setShowHorizontalLines(false);
        jTable1.setShowVerticalLines(false);
        jTable1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jTable1MouseReleased(evt);
            }
        });
        jScrollPane2.setViewportView(jTable1);

        jSplitPane1.setRightComponent(jScrollPane2);

        jMenu1.setText("Program");

        jMenuItem3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/JDiskCat/img/folder-open.png"))); // NOI18N
        jMenuItem3.setText("Open data files location");
        jMenuItem3.setToolTipText("Location of data file storage (operating system dependent-program folder under Windows, user's home folder under Linux).");
        jMenuItem3.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jMenuItem3MouseReleased(evt);
            }
        });
        jMenu1.add(jMenuItem3);

        jMenuItem4.setIcon(new javax.swing.ImageIcon(getClass().getResource("/JDiskCat/img/document-open.png"))); // NOI18N
        jMenuItem4.setText("Import catalog file");
        jMenuItem4.setToolTipText("Import catalog file (XML file) containing volume data. It will be copied to the program data files save location.");
        jMenuItem4.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jMenuItem4MouseReleased(evt);
            }
        });
        jMenu1.add(jMenuItem4);

        jMenuItem5.setIcon(new javax.swing.ImageIcon(getClass().getResource("/JDiskCat/img/preferences-system.png"))); // NOI18N
        jMenuItem5.setText("Options");
        jMenuItem5.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jMenuItem5MouseReleased(evt);
            }
        });
        jMenu1.add(jMenuItem5);

        jMenuItem1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/JDiskCat/img/system-log-out.png"))); // NOI18N
        jMenuItem1.setText("Exit");
        jMenuItem1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jMenuItem1MouseReleased(evt);
            }
        });
        jMenu1.add(jMenuItem1);

        jMenuBar1.add(jMenu1);

        jMenu2.setText("Help");

        jMenuItem2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/JDiskCat/img/dialog-information.png"))); // NOI18N
        jMenuItem2.setText("About JDiskCat...");
        jMenuItem2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jMenuItem2MouseReleased(evt);
            }
        });
        jMenu2.add(jMenuItem2);

        jMenuBar1.add(jMenu2);

        setJMenuBar(jMenuBar1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jToolBar1, javax.swing.GroupLayout.DEFAULT_SIZE, 640, Short.MAX_VALUE)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(jSplitPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 640, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jToolBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSplitPane1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        getAccessibleContext().setAccessibleName("");

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton1MouseReleased
        //Add volume - catalog drive or folder
        JFileChooser chooser;
        chooser = new JFileChooser();
        chooser.setCurrentDirectory(new java.io.File("."));
        chooser.setDialogTitle("Select drive or directory");
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        chooser.setAcceptAllFileFilterUsed(false);//Don't accept all file types

        if (chooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
            dirName = chooser.getSelectedFile().getName();
            System.out.println(dirName.indexOf("./"));
            dirName = dirName.replace("./", "sp4t4A");
            dirName = dirName.replaceAll("sp4t4A", "");
            //Jeśli katalog to napęd pozostaw tylko 1. znak, dla linuxa jest tylko / i tak się nie da (nie wybierać '/'?)
            String tempPath = chooser.getSelectedFile().getPath();
            //linux - test czy dysk
            int temp = tempPath.lastIndexOf("/");
            if (temp != -1) {
                tempPath = tempPath.substring(0, temp);
                System.out.println("Path: " + tempPath);
            }

            Boolean unixDriveDetected = tempPath.equals("/media") || tempPath.equals("/mnt") || tempPath.equals("/Volumes");

            if (chooser.getSelectedFile().getParent() == null || unixDriveDetected) {
                //dirName = dirName.substring(0, 1);//nieaktualne
                FileSystemView view = FileSystemView.getFileSystemView();
                File dir = new File(dirName);
                String name = view.getSystemDisplayName(dir);
                System.out.println("Full name: " + name);
                int index = name.lastIndexOf(" (");//Usunięcie litery dysku i pozostawienie samej nazwy
                System.out.println("Index: " + index + " Length: " + name.length());
                if (index > 0) {
                    //if(index==name.length()-5) System.out.println("Not a Win7 cdrom");
                    if (index < name.length() - 5) {
                        name = name.substring(index + 6, name.length()); //Win7 optical drive hack
                    } else {
                        name = name.substring(0, index);
                    }
                }

                dirName = name;
                System.out.println("Name: " + name);
                File f = new File(chooser.getSelectedFile().getPath());
                System.out.println("Free: " + f.getFreeSpace());
                //if (!f.canWrite() || f.getFreeSpace()==0) {
                if (f.getFreeSpace() == 0) {
                    type = "cdrom";
                } else {
                    type = "hd";
                }
                if (chooser.getSelectedFile().getPath().trim().equals("A:\\") || chooser.getSelectedFile().getPath().trim().equals("B:\\")) {
                    type = "flop";
                }
            } else {
                type = "dir";
            }
            System.out.println("Type: " + type);

            //linux - prowizoryczne rozwiązanie problemu dodawania ./ do ścieżki do nośnika
            diskPath = chooser.getSelectedFile().getPath();
            diskPath = diskPath.replace("./", "sp4t4A");
            diskPath = diskPath.replaceAll("sp4t4A", "");
            //koniec prowizorycznego rozwiązania

            progressWindow.SetProgress(0);
            progressWindow.setVisible(true); //SHOW PROGRESS WINDOW
            dirListThread = new Thread(this);
            dirListThread.start();

        } else {
            System.out.println("Nothing selected!");
        }
    }//GEN-LAST:event_jButton1MouseReleased

    private void jButton2MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton2MouseReleased
        //Remove selected volume
        if (jList1.getSelectedIndex() != -1) {
            selected = (String) jList1.getSelectedValue();
            System.out.println("Selected: " + selected);

            Object[] options = {"Yes",
                "No"};
            int n = JOptionPane.showOptionDialog(this,
                    "Do you wish to remove the volume \"" + selected + "\"?",
                    "Volume deletion",
                    JOptionPane.YES_NO_OPTION,
                    JOptionPane.QUESTION_MESSAGE,
                    null, //null - bez niestandardowej ikony
                    options, //tytuły przycisków
                    options[0]); //nazwa domyślnego przycisku

            if (n == JOptionPane.YES_OPTION) {
                boolean success = (new File(selected + ".xml")).delete();
                if (!success) {
                    System.out.println("Unable to remove " + selected);
                } else {
                    refreshDiskList();
                    tableModel = new DefaultTableModel();
                    jTable1.setModel(tableModel);
                }
            }

        } else {
            System.out.println("Nothing selected!");
        }
    }//GEN-LAST:event_jButton2MouseReleased

    private void jButton3MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton3MouseReleased
        //Go to the root folder of the volume
        goHome();
    }//GEN-LAST:event_jButton3MouseReleased

    private void jList1ValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jList1ValueChanged
        selected = (String) jList1.getSelectedValue();
        path = selected;

        if (selected != null && !selected.isEmpty()) {
            readDisk(selected + ".xml");
            jButton2.setEnabled(true);
            jButton7.setEnabled(true);
            jButton8.setEnabled(true);
            jButton9.setEnabled(true);
        } else {
            jButton2.setEnabled(false);
            jButton7.setEnabled(false);
            jButton8.setEnabled(false);
            jButton9.setEnabled(false);
        }
        jButton3.setEnabled(false);
        jButton4.setEnabled(false);

        jLabel1.setText(path);
    }//GEN-LAST:event_jList1ValueChanged

    private void jMenuItem1MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jMenuItem1MouseReleased
        //Exit program
        System.exit(0);
    }//GEN-LAST:event_jMenuItem1MouseReleased

    private void jButton4MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton4MouseReleased
        //Level up in directory structure (to parent directory)
        levelUp();
    }//GEN-LAST:event_jButton4MouseReleased

    private void jButton5MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton5MouseReleased
        //Open search window
        if (jButton5.isEnabled()) {
            new SearchWindow().setVisible(true);
        }
    }//GEN-LAST:event_jButton5MouseReleased

    private void jMenuItem2MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jMenuItem2MouseReleased
        //Show about window
        new AboutWindow().setVisible(true);
    }//GEN-LAST:event_jMenuItem2MouseReleased

    private void jButton6MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton6MouseReleased
        //Exit program
        System.exit(0);
    }//GEN-LAST:event_jButton6MouseReleased

    private void jTable1MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTable1MouseReleased
        //Enter folder clicked by the user
        //if (evt.getClickCount() == 2) {
        Point p = evt.getPoint();
        int row = jTable1.rowAtPoint(p);
        if (row != -1 && jTable1.getValueAt(row, 1).equals("<DIR>") && jTable1.getSelectedRow() != -1) {
            String value = (String) jTable1.getValueAt(row, 0);
            //int x1 = value.indexOf("[");
            //int x2 = value.lastIndexOf("]");
            //if (x1 != -1 && x2 != -1) {
            //    value = value.substring(x1 + 1, x2);
            //}
            System.out.println(value);
            levelDown(value);
        }
    }//GEN-LAST:event_jTable1MouseReleased

    private void jButton7MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton7MouseReleased
        //Open file in registered application
        int row = jTable1.getSelectedRow();
        if (row != -1 && !jTable1.getValueAt(row, 1).equals("<DIR>") && !jTable1.getValueAt(row, 1).toString().isEmpty() && jTable1.getSelectedRow() != -1) {
            //path z xml np. C:\test zamiant selected w path + \ + nazwa pliku
            //lub path z xml np. C:\ zamiast (selected\) w path + \ +nazwa pliku
            Element rootElement = (Element) root;
            String rootPath = rootElement.getAttribute("path");
            String filePath;
            if (rootPath.trim().length() == 3) {
                int temp = path.indexOf("\\");
                if (temp != -1) {
                    filePath = path.substring(temp + 1);
                    filePath = rootPath + filePath + "\\" + (String) jTable1.getValueAt(row, 0);
                } else {
                    filePath = rootPath + (String) jTable1.getValueAt(row, 0);
                }
            } else {
                int temp = path.indexOf("\\");
                if (temp != -1) {
                    filePath = path.substring(temp + 1);
                    filePath = rootPath + "\\" + filePath + "\\" + (String) jTable1.getValueAt(row, 0);
                } else {
                    filePath = rootPath + "\\" + (String) jTable1.getValueAt(row, 0);
                }
            }

            if (filePath.contains("/")) {
                filePath = filePath.replace('\\', '/');
            }

            System.out.println(filePath);
            File file = new File(filePath);
            if (file.exists()) {
                Desktop desktop;
                if (Desktop.isDesktopSupported()) {
                    desktop = Desktop.getDesktop();
                    try {
                        desktop.open(file);
                    } catch (IOException ex) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                        JOptionPane.showMessageDialog(this,
                                "An error occurred while opening the file. Most likely, no application is associated with that file type.",
                                "Error opening the file.",
                                JOptionPane.ERROR_MESSAGE);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this,
                        "The requested file is not available. Check the availability of volume: \"" + selected + "\".",
                        "Error opening the file.",
                        JOptionPane.ERROR_MESSAGE);
            }
        }
    }//GEN-LAST:event_jButton7MouseReleased

    private void jButton8MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton8MouseReleased
        //Open containing folder
        int row = jTable1.getSelectedRow();
        if (row != -1 && !jTable1.getValueAt(row, 1).equals("<DIR>") && !jTable1.getValueAt(row, 1).toString().isEmpty() && jTable1.getSelectedRow() != -1) {
            //path z xml np. C:\test zamiant selected w path + \ + nazwa pliku
            //lub path z xml np. C:\ zamiast (selected\) w path + \ +nazwa pliku
            Element rootElement = (Element) root;
            String rootPath = rootElement.getAttribute("path");
            String filePath;
            if (rootPath.trim().length() == 3) {
                int temp = path.indexOf("\\");
                if (temp != -1) {
                    filePath = path.substring(temp + 1);
                    filePath = rootPath + filePath;
                } else {
                    filePath = rootPath;
                }
            } else {
                int temp = path.indexOf("\\");
                if (temp != -1) {
                    filePath = path.substring(temp + 1);
                    filePath = rootPath + "\\" + filePath;
                } else {
                    filePath = rootPath;
                }
            }
            if (filePath.contains("/")) {
                filePath = filePath.replace('\\', '/');
            }
            System.out.println(filePath);
            File file = new File(filePath);
            if (file.exists()) {
                Desktop desktop;
                if (Desktop.isDesktopSupported()) {
                    desktop = Desktop.getDesktop();
                    try {
                        desktop.open(file);
                    } catch (IOException ex) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                        JOptionPane.showMessageDialog(this,
                                "An error occurred while opening the folder.",
                                "Error opening folder",
                                JOptionPane.ERROR_MESSAGE);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this,
                        "The requested folder is not available. Check the availability of volume: \"" + selected + "\".",
                        "Error opening folder",
                        JOptionPane.ERROR_MESSAGE);
            }
        }

    }//GEN-LAST:event_jButton8MouseReleased

    private void jButton9MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton9MouseReleased
        //Show volume information
        try {
            File xml = new File(jList1.getSelectedValue().toString() + ".xml");
            long length = xml.length();//XML file size

            String dataSize = "" + length;//XML file size (formatted)

            if (length < 1024) {
                dataSize = "" + length + " B";
            }
            if (length >= 1024 && length < 1048576) {
                double temp = (double) length / 1024;
                dataSize = numberFormat(temp) + " kB";
            }
            if (length >= 1048576 && length < 1073741824) {
                double temp = (double) length / 1048576;
                dataSize = numberFormat(temp) + " MB";
            }
            if (length >= 1073741824) {
                double temp = (double) length / 1073741824;
                dataSize = numberFormat(temp) + " GB";
            }

            //String dataSize = sizeFormat(length);
            System.out.println(length);
            System.out.println(dataSize);
            DocumentBuilderFactory factory2
                    = DocumentBuilderFactory.newInstance();
            DocumentBuilder loader2;
            loader2 = factory2.newDocumentBuilder();
            Document document2;
            document2 = loader2.parse(jList1.getSelectedValue().toString() + ".xml");
            Node root2 = document2.getLastChild();
            Element rootElement = (Element) root2;
            String rootPath = rootElement.getAttribute("path");
            int dirNodes = document2.getElementsByTagName("dir").getLength();
            int fileNodes = document2.getElementsByTagName("file").getLength();
            System.out.println("dirs: " + dirNodes + " files: " + fileNodes);

            if (rootPath.isEmpty()) {
                rootPath = "Unknown";
            }
            String type = rootElement.getAttribute("type");
            if (type.isEmpty()) {
                type = "Unknown";
            }
            if (type.equals("hd")) {
                type = "Harddisk/flash drive partitiom";
            }
            if (type.equals("dir")) {
                type = "Folder";
            }
            if (type.equals("cdrom")) {
                type = "CD/DVD/BD";
            }
            if (type.equals("flop")) {
                type = "Floppy disk";
            }
            JOptionPane.showMessageDialog(this,
                    "Type: " + type + "\nLocation: " + rootPath + "\nFiles: " + fileNodes + "\nFolders: " + dirNodes + "\nCatalog file size: " + dataSize + "\nCatalog file location: " + xml.getAbsolutePath(),
                    "Properties: " + jList1.getSelectedValue().toString(),
                    JOptionPane.INFORMATION_MESSAGE);
        } catch (ParserConfigurationException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("xml parsing error");
        } catch (SAXException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("xml parsing error");
        } catch (IOException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("xml parsing error");
        } catch (HeadlessException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("xml parsing error");
        }
    }//GEN-LAST:event_jButton9MouseReleased

    private void jMenuItem3MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jMenuItem3MouseReleased
        //Open data files location
        java.io.File currentDir = new java.io.File(System.getProperty("user.dir"));
        System.out.println(currentDir.getAbsolutePath());
        //File file = new File(".");
        if (currentDir.exists()) {
            Desktop desktop;
            if (Desktop.isDesktopSupported()) {
                desktop = Desktop.getDesktop();
                try {
                    desktop.open(currentDir);
                } catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                    JOptionPane.showMessageDialog(this,
                            "An error occurred while opening the folder.",
                            "Error opening folder",
                            JOptionPane.ERROR_MESSAGE);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this,
                    "The requested folder is not available.",
                    "Error opening folder",
                    JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_jMenuItem3MouseReleased

    private void jMenuItem4MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jMenuItem4MouseReleased
        //import xml file with volume data
        JFileChooser fc;
        fc = new JFileChooser();
        fc.setCurrentDirectory(new File("."));
        fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
        fc.setFileFilter(new FileNameExtensionFilter("XML data files",
                "xml"));
        if (fc.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
            String xmlName = fc.getSelectedFile().getName();
            System.out.println(xmlName.indexOf("./"));
            xmlName = xmlName.replace("./", "sp4t4A");
            xmlName = xmlName.replaceAll("sp4t4A", "");
            System.out.println(xmlName);
            String f1Path = fc.getSelectedFile().getPath();

            String f2Path;
            int isUnix = f1Path.lastIndexOf("/");
            if (isUnix != -1) {
                f2Path = System.getProperty("user.dir") + "/" + xmlName;
            } else {
                f2Path = System.getProperty("user.dir") + "\\" + xmlName;
            }
            System.out.println("Path1: " + f1Path + "\nPath2: " + f2Path);

            File f1 = new File(f1Path);
            File f2 = new File(f2Path);
            try {
                copyFile(f1, f2);
            } catch (IOException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(this,
                        "An error occurred while importing volume file. Check your write priviledges.",
                        "Error importing catalog file",
                        JOptionPane.ERROR_MESSAGE);
            }

            refreshDiskList();
        } else {
            System.out.println("Nothing selected!");
        }
    }//GEN-LAST:event_jMenuItem4MouseReleased

    private void jMenuItem5MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jMenuItem5MouseReleased
        //display settings window
        settingsWindow.setVisible(true);
    }//GEN-LAST:event_jMenuItem5MouseReleased

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {

                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
                } catch (ClassNotFoundException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                } catch (IllegalAccessException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                } catch (InstantiationException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                } catch (UnsupportedLookAndFeelException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
                new Main().setVisible(true);
            }
        });
    }

    private void dirList(String fname, Boolean firstStage) {

        File dir = new File(fname);
        File[] chld = dir.listFiles();
        if (unix) {//on linux listfiles() outputs folder contents unsorted (tested only on openjdk)
            Arrays.sort(chld);
        }

        if (chld == null) {
            System.out.println("The directory " + fname + " does not exist or is not a directory.");
            JOptionPane.showMessageDialog(this,
                    "Katalog " + fname + " does not exist, is not a directory or you don't have sufficient privileges to read it.",
                    "Error - send error report.",
                    JOptionPane.ERROR_MESSAGE);
            System.exit(0);

        } else {
            for (int i = 0; i < chld.length; i++) {
                if (firstStage) {
                    progressWindow.SetProgress(100 * i / chld.length);
                }

                progressWindow.SetCurrentPath(dir.getAbsolutePath());

                String name = chld[i].getName();
                name = name.replaceAll("&", "&amp;");//parser encounters the & and expects an entity reference because the & signifies the start of an entity reference within XML
                Long modified = chld[i].lastModified();
                java.sql.Timestamp date = new java.sql.Timestamp(modified);

                if (chld[i].isFile() && chld[i].canRead()) {
                    String size = "" + chld[i].length();
                    out.println("<file name=\"" + name + "\" date=\"" + date + "\" size=\"" + size + "\"/>");
                }
                if (chld[i].isDirectory() && chld[i].canRead() && chld[i].listFiles() != null) {
                    out.println("<dir name=\"" + name + "\" date=\"" + date + "\">");
                    dirList(chld[i].getPath(), false);
                    out.println("</dir>");
                }

            }
        }
    }

    private void refreshDiskList() {
        icons = new HashMap<Object, Icon>();
        listModel.clear();
        File dir = new File("."); //kat. programu

        FilenameFilter filter = new FilenameFilter() {
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml") || name.endsWith(".XML");
            }
        };

        File[] chld = dir.listFiles(filter);

        if (chld == null) {
            System.out.println("The selected directory does not exist or is not a directory.");
            System.exit(0); //awaria
        } else {
            //file sorting, suitable for non-Windows OS, without it volumes were listed unsorted
            Arrays.sort(chld, new Comparator() {
                public int compare(Object a, Object b) {
                    File filea = (File) a;
                    File fileb = (File) b;
                    //--- Sort directories before files, 
                    //    otherwise alphabetical ignoring case.
                    if (filea.isDirectory() && !fileb.isDirectory()) {
                        return -1;
                    } else if (!filea.isDirectory() && fileb.isDirectory()) {
                        return 1;
                    } else {
                        return filea.getName().compareToIgnoreCase(fileb.getName());
                    }
                }
            });

            for (int i = 0; i < chld.length; i++) {
                if (chld[i].isFile() && !chld[i].getName().equals("build.xml") && chld[i].length() > 0) {
                    String name = getFileNameWithoutExtension(chld[i].getName());
                    //listModel.addElement(name);

                    try {
                        DocumentBuilderFactory factory2
                                = DocumentBuilderFactory.newInstance();
                        DocumentBuilder loader2;
                        loader2 = factory2.newDocumentBuilder();
                        Document document2;
                        document2 = loader2.parse(chld[i].getName());
                        Node root2 = document2.getLastChild();
                        Element rootElement = (Element) root2;
                        if (rootElement.hasAttribute("type") && rootElement.hasAttribute("name") && rootElement.hasAttribute("path")) { //try to check if the xml file is a valid catalog file
                            listModel.addElement(name);
                            String type = rootElement.getAttribute("type");
                            if (type.isEmpty()) {
                                icons.put(name, null);
                            }
                            if (type.equals("hd")) {
                                icons.put(name, new javax.swing.ImageIcon(getClass().getResource("/JDiskCat/img/drive-harddisk.png")));
                            }
                            if (type.equals("dir")) {
                                icons.put(name, new javax.swing.ImageIcon(getClass().getResource("/JDiskCat/img/folder.png")));
                            }
                            if (type.equals("cdrom")) {
                                icons.put(name, new javax.swing.ImageIcon(getClass().getResource("/JDiskCat/img/media-optical.png")));
                            }
                            if (type.equals("flop")) {
                                icons.put(name, new javax.swing.ImageIcon(getClass().getResource("/JDiskCat/img/media-floppy.png")));
                            }
                        }
                    } catch (ParserConfigurationException ex) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                        System.out.println(ex.getStackTrace().toString());
                        JOptionPane.showMessageDialog(this,
                                "File " + name + ".xml seems to be corrupted and cannot be loaded.",
                                "Error - send error report.",
                                JOptionPane.ERROR_MESSAGE);
                    } catch (SAXException ex) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                        System.out.println(ex.getStackTrace().toString());
                        JOptionPane.showMessageDialog(this,
                                "File " + name + ".xml seems to be corrupted and cannot be loaded.",
                                "Error - send error report.",
                                JOptionPane.ERROR_MESSAGE);
                    } catch (IOException ex) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                        System.out.println(ex.getStackTrace().toString());
                        JOptionPane.showMessageDialog(this,
                                "File " + name + ".xml seems to be corrupted and cannot be loaded.",
                                "Error - send error report.",
                                JOptionPane.ERROR_MESSAGE);
                    }
                }
            }
        }
        jList1.setCellRenderer(new IconListRenderer(icons));
        if (jList1.getModel().getSize() > 0) {
            jButton5.setEnabled(true);
        } else {
            jButton5.setEnabled(false);
        }
    }

    public static String getFileNameWithoutExtension(String fileName) {

        File tmpFile = new File(fileName);
        tmpFile.getName();
        int whereDot = tmpFile.getName().lastIndexOf('.');
        if (0 < whereDot && whereDot <= tmpFile.getName().length() - 2) {
            return tmpFile.getName().substring(0, whereDot);
            //extension = filename.substring(whereDot+1);
        }
        return "";
    }

    private void readDisk(String filename) {
        try {
            DocumentBuilderFactory factory
                    = DocumentBuilderFactory.newInstance();
            loader = factory.newDocumentBuilder();
            document = loader.parse(filename);
            root = document.getLastChild();
            parent = root;
            list = root.getChildNodes();

            refreshTable();
        } catch (Exception e) {
            System.out.println("error: " + e);
            e.printStackTrace();
            JOptionPane.showMessageDialog(this,
                    e.getStackTrace().toString(),
                    "Error - send error report.",
                    JOptionPane.ERROR_MESSAGE);
        }

    }

    private void refreshTable() {
        boolean grayFolderRows = prefs.getBoolean("GRAY_FOLDER_ROWS", false);
        data = new Vector(3);
        Vector row;
        //list directories first then list files
        int tmp = 0;
        for (int i = 0; i < list.getLength(); i++) {
            Node node = list.item(i);
            row = new Vector(3);
            if (node instanceof Element) {
                Element child = (Element) node;
                String attribName = child.getAttribute("name");
                String attribDate = child.getAttribute("date");
                String attribSize = child.getAttribute("size");

                if (attribSize.isEmpty()) {
                    attribSize = "<DIR>";
                    //row.add("[" + attribName + "]");
                    row.add(attribName);
                    row.add(attribSize);
                    row.add(attribDate);
                    data.add(row);
                    if (grayFolderRows) {
                        tmp++;
                    }
                }

            }
        }

        for (int i = 0; i < list.getLength(); i++) {
            Node node = list.item(i);
            row = new Vector(3);
            if (node instanceof Element) {
                Element child = (Element) node;
                String attribName = child.getAttribute("name");
                String attribDate = child.getAttribute("date");
                String attribSize = child.getAttribute("size");
                if (attribSize.isEmpty()) {
                    attribSize = "<DIR>";
                } else {
                    long size = Long.parseLong(attribSize);
                    attribSize = sizeFormat(size);
                }

                row.add(attribName);
                row.add(attribSize);
                row.add(attribDate);
                if (!attribSize.equals("<DIR>")) {
                    data.add(row);
                }
            }
        }
        tableModel = new javax.swing.table.DefaultTableModel(data, columns);
        jTable1.setModel(tableModel);
        //final int tmp2 = tmp;
        
        if (grayFolderRows) {
            jTable1.setDefaultRenderer(Object.class, new DefaultTableCellRenderer() {
                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    final Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    c.setBackground(table.getValueAt(row, 1).toString().equals("<DIR>") ? Color.LIGHT_GRAY : Color.WHITE);
                    c.setForeground(table.getValueAt(row, 1).toString().equals("<DIR>") ? Color.BLACK : Color.BLACK);
                    return c;
                }
            });
            //jTable1.setCellSelectionEnabled(false);
        }
    }

    private void levelDown(String from) {

        for (int i = 0; i < list.getLength(); i++) {
            Node node = list.item(i);
            if (node instanceof Element) {
                Element child = (Element) node;

                String attribName = child.getAttribute("name");
                if (attribName.equals(from)) {
                    parent = node;
                    break;
                }
            }
        }
        path = path + "\\" + from;
        jLabel1.setText(path);
        list = parent.getChildNodes();

        refreshTable();
        jButton3.setEnabled(true);
        jButton4.setEnabled(true);
    }

    private void levelUp() {
        if (parent != root) {
            parent = parent.getParentNode();
            list = parent.getChildNodes();
            refreshTable();

            path = path.substring(0, path.lastIndexOf("\\"));
            jLabel1.setText(path);
            if (path.lastIndexOf("\\") == -1) {
                jButton3.setEnabled(false);
                jButton4.setEnabled(false);
            }
        }
    }

    private void goHome() {
        if (parent != root) {
            parent = root;
            list = parent.getChildNodes();
            refreshTable();

            path = selected;
            jLabel1.setText(path);
            jButton3.setEnabled(false);
            jButton4.setEnabled(false);
        }
    }

    class IconListRenderer extends DefaultListCellRenderer {

        private Map<Object, Icon> icons = null;

        public IconListRenderer(Map<Object, Icon> icons) {
            this.icons = icons;
        }

        @Override
        public Component getListCellRendererComponent(
                JList list, Object value, int index,
                boolean isSelected, boolean cellHasFocus) {

            JLabel label
                    = (JLabel) super.getListCellRendererComponent(list,
                            value, index, isSelected, cellHasFocus);

            Icon icon = icons.get(value);

            label.setIcon(icon);
            return label;
        }
    }

    public static String getSelected() {
        return selected;
    }

    public static int getSelectedIndex() {
        return jList1.getSelectedIndex();
    }

    public void run() {
        jButton1.setEnabled(false);
        try {
            FileOutputStream fos
                    = new FileOutputStream(dirName + ".xml");
            OutputStreamWriter osw
                    = new OutputStreamWriter(fos, "UTF8");

            File disk = new File(diskPath);
            if (disk.listFiles() != null && disk.canRead()) {
                out = new PrintWriter(osw);
                out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                out.println("<vol name=\"" + dirName + "\" path=\"" + diskPath + "\" type=\"" + type + "\">");
                System.out.println("path: " + diskPath);

                long start = System.currentTimeMillis();
                dirList(diskPath, true); //Katalogowanie
                long stop = System.currentTimeMillis();
                float runTime = stop - start;
                runTime /= 1000;
                System.out.println("Cataloging duration: " + runTime + " s");
                jLabel1.setText("Cataloging duration: " + runTime + " s");

                out.println("</vol>");
                out.close();
                out = null;
                refreshDiskList();
            } else {
                JOptionPane.showMessageDialog(this,
                        "Directory " + dirName + " doesn't exist or you don's have sufficient priviledges to read it.",
                        "Error",
                        JOptionPane.ERROR_MESSAGE);
            }

        } catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this,
                    e.getStackTrace().toString(),
                    "Error - send error report to author",
                    JOptionPane.ERROR_MESSAGE);
        }
        jButton1.setEnabled(true);
        progressWindow.setVisible(false); //HIDE PROGRESS WINDOW
    }

    public static DefaultListModel getDiskList() {
        return listModel;
    }

    public static String numberFormat(double value) {
        String pattern = "###.##";
        DecimalFormat myFormatter = new DecimalFormat(pattern);
        String output = myFormatter.format(value);
        return output;
    }

    public static String sizeFormat(long length) {
        String dataSize = "" + length;//XML file size (formatted)
        nerdMode = prefs.getBoolean("NERD_MODE", false);
        if (!nerdMode) {
            if (length < 1024) {
                dataSize = "" + length + " B";
            }
            if (length >= 1024 && length < 1048576) {
                double temp = (double) length / 1024;
                dataSize = numberFormat(temp) + " kB";
            }
            if (length >= 1048576 && length < 1073741824) {
                double temp = (double) length / 1048576;
                dataSize = numberFormat(temp) + " MB";
            }
            if (length >= 1073741824) {
                double temp = (double) length / 1073741824;
                dataSize = numberFormat(temp) + " GB";
            }
        }

        return dataSize;
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }

        FileChannel source = null;
        FileChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            destination.transferFrom(source, 0, source.size());
        } finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
            System.out.println("File cloned");
        }
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JButton jButton5;
    private javax.swing.JButton jButton6;
    private javax.swing.JButton jButton7;
    private javax.swing.JButton jButton8;
    private javax.swing.JButton jButton9;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private static javax.swing.JList jList1;
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenu jMenu2;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JMenuItem jMenuItem2;
    private javax.swing.JMenuItem jMenuItem3;
    private javax.swing.JMenuItem jMenuItem4;
    private javax.swing.JMenuItem jMenuItem5;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JToolBar.Separator jSeparator1;
    private javax.swing.JToolBar.Separator jSeparator2;
    private javax.swing.JToolBar.Separator jSeparator3;
    private javax.swing.JToolBar.Separator jSeparator4;
    private javax.swing.JSplitPane jSplitPane1;
    private static javax.swing.JTable jTable1;
    private javax.swing.JToolBar jToolBar1;
    // End of variables declaration//GEN-END:variables
}
